#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//MENGERSPONGEMod01.fsh   by   vlams1 
//https://www.shadertoy.com/view/WtfXzj
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//Rewritten as of 27-09-2019

#define it 1024.
#define pr .00001
#define md 200.

mat2 rotate(float a) {
    float s = sin(radians(a));
    float c = cos(radians(a));
    return mat2(c,-s,s,c);
}

//Menger sponge SDF by fb39ca4
//https://www.shadertoy.com/user/fb39ca4

float sdCross(vec3 p) {
	p = abs(p);
	vec3 d = vec3(max(p.x, p.y),
				  max(p.y, p.z),
				  max(p.z, p.x));
	return min(d.x, min(d.y, d.z)) - (1.0 / 3.0);
}

float sdCrossRep(vec3 p) {
	vec3 q = mod(p + 1.0, 2.0) - 1.0;
	return sdCross(q);
}

float sdCrossRepScale(vec3 p, float s) {
	return sdCrossRep(p * s) / s;	
}

float sdScene(vec3 p) {
    float s = 1.0;
	float d = 0.0;
	for (int i = 0; i < 5; i++) {
		d = max(d, -sdCrossRepScale(p, s));
		s *= 3.0;
	}
	return d;
}

vec4 raymarch(vec3 ro, vec3 rd) {
    vec3 p = ro;
    float d;
    float i;
    for (i=0.; i < it; i++) {
        d = sdScene(p);
        p += rd*d;
        if (d < pr) break;
    }
    return vec4(p,i);
}

vec3 normals(vec3 p) {
    vec2 o = vec2(pr,0.0);
    return normalize(vec3(
        sdScene(p+o.xyy)-sdScene(p-o.xyy),
        sdScene(p+o.yxy)-sdScene(p-o.yxy),
        sdScene(p+o.yyx)-sdScene(p-o.yyx)));
}

float ambientOcclusion(vec3 p, vec3 n, float s, float iterations, float intensity) {
    float ao = 0.0;
    for (float i = 1.0; i <= iterations; i++) {
        float d = s * i;
        ao += max((d - sdScene(p + n * d)) / d, 0.0);
    }
    return 1.0 - ao * intensity;
}



//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{      
    vec2 uv = fragCoord/iResolution.xy*2.-1.;
    uv.y *= iResolution.y/iResolution.x;
    
    vec4 mouse = vec4(iMouse.xy / iResolution.xy * 2.0 - 1.0,iMouse.zw); //Mouse input
    
    vec3 ro = vec3(0.0,0.0,mod(iTime,2.0));
    vec3 rd = normalize(vec3(uv,0.6));
    rd.xy *= rotate(iTime*15.);
        
    vec3 col = vec3(1.);
    
    vec4 rm = raymarch(ro,rd);
    vec3 p = rm.xyz;
    vec3 n = normals(p);
    col = mix(vec3(ambientOcclusion(p, n, 0.4, 5.0, 0.2)), vec3(0.6,0.2,0.8), length(p-ro)/5.0) + rm.w / it;
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

